# Формат пакета данных от датчиков c LoRaWAN

- [Формат пакета данных от датчиков c LoRaWAN](#формат-пакета-данных-от-датчиков-c-lorawan)
  - [Структура пакета с данными](#структура-пакета-с-данными)
  - [Описание доступных типов данных](#описание-доступных-типов-данных)
    - [Тип данных **VALUE\_t**](#тип-данных-value_t)
    - [Тип данных **STATUS\_t**](#тип-данных-status_t)
    - [Тип данных **SI\_TYPE\_e**](#тип-данных-si_type_e)
    - [Тип данных **SELF\_STATE\_t**](#тип-данных-self_state_t)
    - [Тип данных **CONF\_GETBLOCK\_t**](#тип-данных-conf_getblock_t)
    - [Тип данных **RSSI\_SNR\_t**](#тип-данных-rssi_snr_t)
    - [Тип данных **CONF\_DEVICE\_INFO\_t**](#тип-данных-conf_device_info_t)
    - [Тип данных **CONF\_THRESHOLD\_t**](#тип-данных-conf_threshold_t)
    - [Тип данных **CONF\_MEASURE\_t**](#тип-данных-conf_measure_t)
    - [Тип данных **CONF\_LORA\_t**](#тип-данных-conf_lora_t)
    - [Тип данных **CONF\_REED\_t**](#тип-данных-conf_reed_t)
  - [Пример декодирования](#пример-декодирования)

## Структура пакета с данными

Структура пакета с данными имеет переменную длину и может содержать до **8** различных параметров, передаваемых от датчика.  
И имеет следующую структуру:

```c
typedef struct {
    union{
        LORA_VALUE_t payload[];
        uint8_t raw[48];
    }DATA_u;
}LORA_MESSAGE_t;
```

Каждый параметр (**LORA_VALUE_t**) в свою очередь описывается структурой:

```c
typedef struct{
    LORA_MESSAGE_TYPE_e  type;    //тип данных
    uint8_t              value[]; //массив с данными, LittleEndian
}LORA_VALUE_t;
```
**Внимание !** Данные отправляются и принимаются на FPort равном 2  

Доступные типы данных **LORA_MESSAGE_TYPE_e**
| Значение  | Описание                                              | Тип               | Размер  |
|:--------: |----------------------------------------------------   |:----------------: |:-------:|
| 0, 0x01   | Ток прибора                                         | IEE754 Float        | 4       |
| 1, 0x01   | Значение первичной величины                         | [VALUE_t](#тип-данных-value_t)          | 5       |
| 2, 0x02   | Значение статуса работы устройства                  | STATUS_t                                | 1       |
| 3, 0x03   | Уникальный номер прибора                            | uint24_t                                | 3       |
| 4, 0x04   | Минимальное значение диапазона измерения PV         | [VALUE_t](#тип-данных-value_t)          | 5       |
| 5, 0x05   | Максимальное значение диапазона измерения PV        | [VALUE_t](#тип-данных-value_t)          | 5       |
| 6, 0x06   | Значение дополнительного статуса устройства         | зарезервировано     | 4       |
| 7, 0x07   | Значение процента от диапазона измерения            | IEE754 Float        | 4       |
| 8, 0x08   | Уникальный адрес устройства для LoRa P2P            | LoRa DevAddr        | 4       |
| 9, 0x09   | Интервал измерения и передачи для LoRa P2P          | internal            | 4       |
| 10, 0x0A  | Подтверждение приема для LoRa P2P                   | internal            | 1       |
| 11, 0x0B  | Идентификатор пакета LoRa P2P                       | internal            | 4       |
| 12, 0x0C  | Оставшийся процент элемента питания                 | IEE754 Float        | 4       |
| 13, 0x0D  | Уровень RSSI и SNR от принятого сообщения прибором  | [RSSI_SNR_t](#тип-данных-rssi_snr_t)            | 4       |
| 14, 0x0E  | Значение статуса работы радиопередатчика            | [SELF_STATE_t](#тип-данных-self_state_t)        | 2       |
| 15, 0x0F  | Запрос параметров устройства                        | [CONF_GETBLOCK_t](#тип-данных-conf_getblock_t)        |  2      |
| 16, 0x10  | Параметры «Информация об устройстве»                | [CONF_DEVICE_INFO_t](#тип-данных-conf_device_info_t)  |  13     |
| 17, 0x11  | Параметры «Отслеживание пороговых значений»         | [CONF_THRESHOLD_t](#тип-данных-conf_threshold_t)      |  15     |
| 18, 0x12  | Параметры «Измерение и передача»                    | [CONF_MEASURE_t](#тип-данных-conf_measure_t)          |  4      |
| 19, 0x13  | Параметры «LoRa»                                    | [CONF_LORA_t](#тип-данных-conf_lora_t)                |  7      |
| 20, 0x14  | Параметры «Бесконтактный переключатель»             | [CONF_REED_t](#тип-данных-conf_reed_t)                |  2      |
| 21, 0x15  | Время и дата                                        | UNIX-time                               |  4      |
| 22, 0x16  | Значение вторичной величины (SV)                    | [VALUE_t](#тип-данных-value_t)          | 5       |
| 23, 0x17  | Минимальное значение диапазона измерения SV         | [VALUE_t](#тип-данных-value_t)          | 5       |
| 24, 0x18  | Максимальное значение диапазона измерения SV        | [VALUE_t](#тип-данных-value_t)          | 5       |
| 25, 0x19  | Значение третичной величины (TV)                    | [VALUE_t](#тип-данных-value_t)          | 5       |
| 26, 0x1A  | Минимальное значение диапазона измерения TV         | [VALUE_t](#тип-данных-value_t)          | 5       |
| 27, 0x1B  | Максимальное значение диапазона измерения TV        | [VALUE_t](#тип-данных-value_t)          | 5       |
| 28, 0x1C  | Значение четверичной величины (QV)                  | [VALUE_t](#тип-данных-value_t)          | 5       |
| 29, 0x1D  | Минимальное значение диапазона измерения QV         | [VALUE_t](#тип-данных-value_t)          | 5       |
| 30, 0x1E  | Максимальное значение диапазона измерения QV        | [VALUE_t](#тип-данных-value_t)          | 5       |

## Описание доступных типов данных

### Тип данных **VALUE_t**

|Байт     | Описание                                                | Тип               | Размер    |
|:--------: |----------------------------------------------------   |:----------------: |:-------:  |
| 0         | Величина СИ                                           | SI_TYPE_e         | 1         |
| 1 - 4     | Значение                                              | IEE754 Float      | 4         |

### Тип данных **STATUS_t**

|Байт     | Описание                                                | Тип               | Размер  |
|:--------: |----------------------------------------------------   |:----------------: |:-------: |
| 0         |<table><thead> <tr> <th>Бит</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Первичная величина за диапазоном измерения</td> </tr> <tr> <td>1</td> <td>Вторичная величина за диапазоном измерения</td> </tr> <tr> <td>2</td> <td>Токовая петля в насыщении</td> </tr> <tr> <td>3</td> <td>Токовая петля в фиксированном значении</td> </tr> <tr> <td>4</td> <td>Доступны дополнительные статусы работы устройства</td> </tr> <tr> <td>5</td> <td>Холодный старт</td> </tr> <tr> <td>6</td> <td>Конфигурация изменена</td> </tr> <tr> <td>7</td> <td>Устройство неисправно</td> </tr></tbody></table>| Битовое поле      | 1       |

### Тип данных **SI_TYPE_e**

|Байт       | Описание                                              | Тип                   | Размер    |
|:--------: |----------------------------------------------------   |:----------------:     |:-------:  |
|   0       |<table><thead> <tr> <th>Значение</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Неопределена</td> </tr> <tr> <td>1</td> <td>inH2O, дюймы вод. ст. при 20 градусах Цельсия</td> </tr> <tr> <td>2</td> <td>inHg, дюймы рт. ст.</td> </tr> <tr> <td>3</td> <td>ftH2O, футы вод. ст. при 20 градусах Цельсия</td> </tr> <tr> <td>4</td> <td>mmH2O, мм вод. ст. при 20 градусах Цельсия</td> </tr> <tr> <td>5</td> <td>mmHg, мм рт. ст. при 0 градусах Цельсия</td> </tr> <tr> <td>6</td> <td>psi, фунт на квадратный дюйм</td> </tr> <tr> <td>7</td> <td>bar, бар</td> </tr> <tr> <td>8</td> <td>mBar, миллибар</td> </tr> <tr> <td>9</td> <td>g/cm2, грамм силы на сантиметр квадратный</td> </tr> <tr> <td>10</td> <td>kg/cm2, килограмм силы на сантиметр квадратный</td> </tr> <tr> <td>11</td> <td>Pa, паскаль </td> </tr> <tr> <td>12</td> <td>kPa, килопаскаль</td> </tr> <tr> <td>13</td> <td>Torr, торр </td> </tr> <tr> <td>14</td> <td>atm, атмосфера</td> </tr> <tr> <td>32</td> <td>°С, градус Цельсия</td> </tr> <tr> <td>33</td> <td>°F, градус Фаренгейта </td> </tr> <tr> <td>34</td> <td>°Ra, градус Ранкина</td> </tr> <tr> <td>35</td> <td>K, градус Цельсия</td> </tr> <tr> <td>36</td> <td>mV, милливольты </td> </tr> <tr> <td>37</td> <td>Ohm, сопротивление в Омах</td> </tr> <tr> <td>39</td> <td>mA, миллиамперы</td> </tr> <tr> <td>57</td> <td>%, проценты</td> </tr> <tr> <td>58</td> <td>V, вольты</td> </tr> <tr> <td>145</td> <td>inH2O (60 °F), дюймы вод. ст. при 60 градусах Фаренгейта</td> </tr> <tr> <td>163</td> <td>kΩ, килоомы</td> </tr> <tr> <td>170</td> <td>cmH2O (4 °C), сантиметры вод. ст. при 4 градусах Цельсия</td> </tr> <tr> <td>171</td> <td>mH2O (4 °C), метры вод. ст. при 4 градусах Цельсия</td> </tr> <tr> <td>172</td> <td>cmHg, сантиметры рт. ст. при 0 градусах Цельсия</td> </tr> <tr> <td>173</td> <td>lb/ft2, фунт на квадратный фут</td> </tr> <tr> <td>174</td> <td>hPa, гектопаскаль</td> </tr> <tr> <td>175</td> <td>psia, фунт на квадратный дюйм абсолютный</td> </tr> <tr> <td>176</td> <td>kg/m2, килограмм силы на метр квадратный</td> </tr> <tr> <td>177</td> <td>ftH2O (4 °C), футы вод. ст. при 4 градусах Цельсия</td> </tr> <tr> <td>178</td> <td>ftH2O (60 °F), футы вод. ст. при 60 градусах Фаренгейта</td> </tr> <tr> <td>179</td> <td>mHg, метры рт. ст. при 0 градусах Цельсия</td> </tr> <tr> <td>180</td> <td>Mpsi, мегафунт на квадратный дюйм</td> </tr> <tr> <td>181</td> <td>oz/in2, унция на квадратный дюйм</td> </tr> <tr> <td>237</td> <td>MPa, мегапаскаль</td> </tr> <tr> <td>238</td> <td>inH2O (4 °C), дюймы вод. ст. при 4 градусах Цельсия</td> </tr> <tr> <td>239</td> <td>mmH2O (4 °C), мм вод. ст. при 4 градусах цельсия</td></tbody></table>                                                       | Enum          | 1         |

### Тип данных **SELF_STATE_t**

|Байт       | Описание                                            | Тип               | Размер      |
|:--------: |---------------------------------------------------- |:----------------: |:-------:    |
| 0         |<table><thead> <tr> <th>Бит</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Поврежден сектор с заводскими настройкам прибора</td> </tr> <tr> <td>1</td> <td>Поврежден сектор с резервными настройками прибора</td> </tr> <tr> <td>2</td> <td>Поврежден сектор с настройками прибора</td> </tr> <tr> <td>3</td> <td>Ошибка АЦП</td> </tr> <tr> <td>4</td> <td>Ошибка вторичного преобразователя</td> </tr> <tr> <td>5</td> <td>Активирован магнитный переключатель, геркон</td> </tr> <tr> <td>6</td> <td>Ошибка встроенного архива измерений</td> </tr> <td>7</td> <td>Ошибка FRAM</td> </tr> </tbody></table>| Битовое поле | 1|
| 1         | <table><thead> <tr> <th>Бит</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Активирован пороговый детектор по минимальной границе</td> </tr> <tr> <td>1</td> <td>Активирован пороговый детектор по максимальной границе</td> </tr> <tr> <td>2-7</td> <td>Зарезервировано</td> </tr></tbody></table>   | Битовое поле  | 1 |

### Тип данных **CONF_GETBLOCK_t**

**Внимание!**  
При запросе необходимо учитывать максимальную длину ответного пакета для радиопередачи: для режимов LoRaWAN DR0 - DR2 она составляет **53 байта**  

|Байт       | Описание                                            | Тип               | Размер      |
|:--------: |---------------------------------------------------- |:----------------: |:-------:    |
| 0         |<table><thead> <tr> <th>Бит</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Блок "Информация об устройстве"</td> </tr> <tr> <td>1</td> <td>Блок "Отслеживания пороговых значений"</td> </tr> <tr> <td>2</td> <td>Блок "Измерение и передача"</td> </tr> <tr> <td>3</td> <td>Блок "LoRa"</td> </tr> <tr> <td>4</td> <td>Блок "Бесконтактный переключатель"</td> </tr> <tr> <td>5 - 7</td> <td>Зарезервировано</td> </tr></tbody></table>| Битовое поле | 1|
| 1         |<table><thead> <tr> <th>Бит</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0 - 7</td> <td>Зарезервировано</td></tr></tbody></table>| Битовое поле | 1|

### Тип данных **RSSI_SNR_t**

|Байт       | Описание                                              | Тип               | Размер  |
|:--------: |----------------------------------------------------   |:----------------: |:-------:|
| 0 - 1     | RSSI                                                  | int16_t           | 2       |
| 2 - 3     | SNR                                                   | int16_t           | 2       |

### Тип данных **CONF_DEVICE_INFO_t**

|Байт       | Описание                                            | Тип               | Размер      |
|:--------: |---------------------------------------------------- |:----------------: |:-------:    |
| 0 - 1     | Версия ПО                                             | (major << 8) + minor| 2       |
| 2 - 3     | Версия аппаратного обеспечения                        | (major << 8) + minor| 2       |
| 4 - 7     | Контрольная сумма ПО                                  | uint32_t         | 4          |
| 8 - 11    | Контрольная сумма метрологической части ПО            | uint32_t         | 4          |
| 12     | Способ измерения                                         | <table><thead> <tr> <th>Значение</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Токовая петля</td> </tr> <tr> <td>1</td> <td>HART</td> </tr> <tr> <td>2</td> <td>SWIRE</td> </tr></tbody></table>         | 1       |

### Тип данных **CONF_THRESHOLD_t**

|Байт       | Описание                                            | Тип               | Размер      |
|:--------: |---------------------------------------------------- |:----------------: |:-------:    |
| 0         | Отслеживаемый параметр                                | <table><thead> <tr> <th>Значение</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Ток</td> </tr> <tr> <td>1</td> <td>PV</td> </tr> <tr> <td>2</td> <td>Процент</td> </tr></tbody></table>           | 1       |
| 1 - 4     | Значение MIN                                          | IEE754 Float          | 4       |
| 5 - 8     | Значение MAX                                          | IEE754 Float          | 4       |
| 9 - 12    | Значение гистерезиса                                  | IEE754 Float          | 4       |
| 13        | Отслеживать падение ниже уровня (MIN - гистерезис)    | bool                  | 1       |
| 14        | Отслеживать превышение над уровнем (MAX + гистерезис) | bool                  | 1       |

### Тип данных **CONF_MEASURE_t**

|Байт       | Описание                                            | Тип               | Размер      |
|:--------: |---------------------------------------------------- |:----------------: |:-------:    |
| 0      | Отправляемая переменная                             |<table><thead> <tr> <th>Значение</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>Установленный ток</td> </tr> <tr> <td>1</td> <td>PV и %</td> </tr></tbody></table>           | 1       |
| 1      | Время выхода на режим, в сек                          | uint8_t, от 4 до 15           | 1       |
| 2      | Интервал передачи,  в мин                             | uint8_t, от 1 до 30           | 1       |
| 3      | Интервал измерения, в мин                             | uint8_t, от 1 до 240          | 1       |

### Тип данных **CONF_LORA_t**

|Байт       | Описание                                            | Тип               | Размер      |
|:--------: |---------------------------------------------------- |:----------------: |:-------:    |
| 0         | Кол-во попыток передачи                             | uint8_t, от 1 до 10          | 1       |
| 1         | Скорость передачи данных                            | <table><thead> <tr> <th>Значение</th> <th>Описание</th> </tr></thead><tbody> <tr> <td>0</td> <td>DR0</td> </tr> <tr> <td>1</td> <td>DR1</td> </tr> <tr> <td>2</td> <td>DR2</td> </tr> <tr> <td>3</td> <td>DR3</td> </tr> <tr> <td>4</td> <td>DR4</td> </tr> <tr> <td>5</td> <td>DR5</td> </tr></tbody></table>                       | 1       |
| 2         | Мощность передатчика                                | uint8_t, от 0 до 14     | 1       |
| 3         | Активность LBT/CAD                                  | bool                    | 1       |
| 4-5       | Уровень RSSI для LBT                                | int16_t, от -125 до 0   | 1       |
| 6         | Время сканирования эфира LBT, в мсек                | uint8_t, от 5 до 250    | 1       |

### Тип данных **CONF_REED_t**

|Байт       | Описание                                            | Тип               | Размер      |
|:--------: |---------------------------------------------------- |:----------------: |:-------:    |
| 0         | Активность бесконтактного переключателя "геркон"    | bool                | 1         |
| 1         | Время выхода на режим при срабатывании, в сек       | uint8_t, от 4 до 15 | 1         |

## Пример декодирования  

Принятый пакет с данными ```[02000078BE7F40]```

```0x02``` – Тип «Значение статуса работы устройства»  
```0x00``` – значение  
```0x00``` – Тип «Ток прибора»  
```[0x78, 0xBE, 0x7F, 0x40]``` Значение в IEE754 Float , от младшего к старшему  

```json
{
    Status: {
        PrimaryVariableOutOfLimits: false,
        NonPrimaryVariableOutOfLimits: false,
        LoopCurrentSaturated: false,
        MoreStatusAvailable: false,
        ColdStart: false,
        ConfigurationChanged: false,
        DeviceMalfunction: false
    }
    Current: {value: '3.996'}
}
```

Принятый пакет с данными ```[140106 0e1000 0c84ffc742 104601140188af3fdd0000000001 11020000a0410000a0420000a0400000 1201040303 1303050800b0ff01]```

```json
{
  ConfREED: { IsReedActive: true, ReedWarmUpDelay: 6 },
  ConfREEDRaw: { value: '0106', si: 'Undef' },
  SelfState: {
    ErrorFactorySettings: false,
    ErrorReservedSettings: false,
    ErrorUserSettings: false,
    ErrorADC: false,
    ErrorTransmitter: true,
    IsReedBeenActivated: false
  },
  SelfStateRaw: { value: '0x10', si: 'Undef' },
  Battery: { value: 99.999, si: '%' },
  ConfDEVICEINFO: {
    VersionFW: '1.70',
    VersionHW: '1.20',
    CRC_FW: '0xdd3faf88',
    CRR_Metrolog: '0x0',
    MeasureMethod: 'HART'
  },
  ConfDEVICEINFORaw: { value: '4601140188af3fdd0000000001', si: 'Undef' },
  ConfTHRESHOLD: {
    InitialValue: 'Percent',
    ThresholdMin: 20,
    ThresholdMax: 80,
    ThresholdHyst: 5,
    ThresholdEnMin: false,
    ThresholdEnMax: false
  },
  ConfTRESHOLDRaw: { value: '020000a0410000a0420000a0400000', si: 'Undef' },
  ConfMEASURE: {
    SendVar: 'Pv & Percent',
    WarmUpDelay: 4,
    SendPeriodMins: 3,
    MeasurePeriodMins: 3
  },
  ConfMEASURERaw: { value: '01040303', si: 'Undef' },
  ConfLoRa: {
    RetransmissionCount: 3,
    DR: 5,
    TxPower: 8,
    IsLBTEnable: false,
    LBTRSSI: -80,
    LBTScanTime: 1
  },
  ConfLORARaw: { value: '03050800b0ff01', si: 'Undef' }
}
```
